<?php

namespace Unific\Connector\Model\Api\Data;

use Unific\Connector\Api\Data\FiltersInterface;
use Magento\Framework\DataObject;

class Filters extends DataObject implements FiltersInterface
{
    /**#@+
     * Constants for keys of data array
     */
    const TYPE = 'type';
    const START_DATETIME = 'start_datetime';
    const END_DATETIME = 'end_datetime';
    const DATE_FIELD = 'date_field';
    const IDENTIFIERS = 'identifiers';
    /**#@-*/

    public function getType()
    {
        return $this->getData(self::TYPE);
    }

    public function setType($type)
    {
        return $this->setData(self::TYPE, $type);
    }

    public function getStartDatetime()
    {
        return $this->getData(self::START_DATETIME);
    }

    public function setStartDatetime($startDatetime)
    {
        return $this->setData(self::START_DATETIME, $startDatetime);
    }

    public function getEndDatetime()
    {
        return $this->getData(self::END_DATETIME);
    }

    public function setEndDatetime($endDatetime)
    {
        return $this->setData(self::END_DATETIME, $endDatetime);
    }

    public function getDateField()
    {
        return $this->getData(self::DATE_FIELD);
    }

    public function setDateField($dateField)
    {
        return $this->setData(self::DATE_FIELD, $dateField);
    }

    public function getIdentifiers()
    {
        return $this->getData(self::IDENTIFIERS);
    }

    public function setIdentifiers($identifiers)
    {
        return $this->setData(self::IDENTIFIERS, $identifiers);
    }
}
