<?php

namespace Unific\Connector\Api\Data;

use Magento\Framework\Api\ExtensibleDataInterface;

interface HmacInterface extends ExtensibleDataInterface
{
    /**
     * @return string|null
     */
    public function getHmacHeader();

    /**
     * @param string $hmacHeader
     * @return $this
     */
    public function setHmacHeader($hmacHeader);

    /**
     * @return string|null
     */
    public function getHmacSecret();

    /**
     * @param string $hmacSecret
     * @return $this
     */
    public function setHmacSecret($hmacSecret);

    /**
     * @return string|null
     */
    public function getHmacAlgorithm();

    /**
     * @param string $hmacAlgorithm
     * @return $this
     */
    public function setHmacAlgorithm($hmacAlgorithm);

    /**
     * Retrieve existing extension attributes object or create a new one.
     *
     * @return \Unific\Connector\Api\Data\HmacExtensionInterface|null
     */
    public function getExtensionAttributes();

    /**
     * Set an extension attributes object.
     *
     * @param \Unific\Connector\Api\Data\HmacExtensionInterface $extensionAttributes
     * @return $this
     */
    public function setExtensionAttributes(
        \Unific\Connector\Api\Data\HmacExtensionInterface $extensionAttributes
    );
}
