<?php

namespace Unific\Connector\Model\Api\Data;

use Unific\Connector\Api\Data\HistoricalResultInterface;
use Magento\Framework\DataObject;

class HistoricalResult extends DataObject implements HistoricalResultInterface
{
    const MESSAGE = 'message';

    /**
     * Get the message
     *
     * @return string|null
     */
    public function getMessage()
    {
        return $this->getData(self::MESSAGE);
    }

    /**
     * Set the message
     *
     * @param string $message
     * @return $this
     */
    public function setMessage($message)
    {
        return $this->setData(self::MESSAGE, $message);
    }
}
