<?php

namespace Unific\Connector\Model\Api\Data;

use Magento\Framework\DataObject;

class Hmac extends DataObject implements \Unific\Connector\Api\Data\HmacInterface
{
    const KEY_HMAC_HEADER = 'hmac_header';
    const KEY_HMAC_SECRET = 'hmac_secret';
    const KEY_HMAC_ALGORITHM = 'hmac_algorithm';
    const KEY_EXTENSION_ATTRIBUTES = 'extension_attributes';

    /**
     * @return string|null
     */
    public function getHmacHeader()
    {
        return $this->getData(self::KEY_HMAC_HEADER);
    }

    /**
     * @param string $hmac_header
     * @return $this
     */
    public function setHmacHeader($hmac_header)
    {
        return $this->setData(self::KEY_HMAC_HEADER, $hmac_header);
    }

    /**
     * @return string|null
     */
    public function getHmacSecret()
    {
        return $this->getData(self::KEY_HMAC_SECRET);
    }

    /**
     * @param string $hmac_secret
     * @return $this
     */
    public function setHmacSecret($hmac_secret)
    {
        return $this->setData(self::KEY_HMAC_SECRET, $hmac_secret);
    }

    /**
     * @return string|null
     */
    public function getHmacAlgorithm()
    {
        return $this->getData(self::KEY_HMAC_ALGORITHM);
    }

    /**
     * @param string $hmac_algorithm
     * @return $this
     */
    public function setHmacAlgorithm($hmac_algorithm)
    {
        return $this->setData(self::KEY_HMAC_ALGORITHM, $hmac_algorithm);
    }

    /**
     * {@inheritdoc}
     */
    public function getExtensionAttributes()
    {
        return $this->getData(self::KEY_EXTENSION_ATTRIBUTES);
    }

    /**
     * {@inheritdoc}
     */
    public function setExtensionAttributes(
        \Unific\Connector\Api\Data\HmacExtensionInterface $extensionAttributes
    ) {
        return $this->setData(self::KEY_EXTENSION_ATTRIBUTES, $extensionAttributes);
    }
}
