<?php

namespace Unific\Connector\Model\Api\Data;

use Magento\Framework\DataObject;

class Integration extends DataObject implements \Unific\Connector\Api\Data\IntegrationInterface
{
    const KEY_INTEGRATION_ID = 'integration_id';
    const KEY_ENDPOINT = 'endpoint';
    const KEY_EXTENSION_ATTRIBUTES = 'extension_attributes';

    /**
     * @return string|null
     */
    public function getIntegrationId()
    {
        return $this->getData(self::KEY_INTEGRATION_ID);
    }

    /**
     * @param string $id
     * @return $this
     */
    public function setIntegrationId($id)
    {
        return $this->setData(self::KEY_INTEGRATION_ID, $id);
    }

    /**
     * @return string|null
     */
    public function getEndpoint()
    {
        return $this->getData(self::KEY_ENDPOINT);
    }

    /**
     * @param string $endpoint
     * @return $this
     */
    public function setEndpoint($endpoint)
    {
        return $this->setData(self::KEY_ENDPOINT, $endpoint);
    }

    /**
     * {@inheritdoc}
     */
    public function getExtensionAttributes()
    {
        return $this->getData(self::KEY_EXTENSION_ATTRIBUTES);
    }

    /**
     * {@inheritdoc}
     */
    public function setExtensionAttributes(
        \Unific\Connector\Api\Data\IntegrationExtensionInterface $extensionAttributes
    ) {
        return $this->setData(self::KEY_EXTENSION_ATTRIBUTES, $extensionAttributes);
    }
}
