<?php

namespace Unific\Connector\Plugin\FixtureGenerator;

use Magento\Setup\Model\FixtureGenerator\EntityGenerator;
use Magento\Setup\Model\FixtureGenerator\EntityGeneratorFactory;

/**
 * Class UpdateCustomTableMapPlugin
 * @package Unific\Connector\Plugin\FixtureGenerator
 */
class UpdateCustomTableMapPlugin
{
    /**
     * Inject unific_Connector_message_queue table data to FixtureGenerator\EntityGeneratorFactory arguments.
     *
     * @param EntityGeneratorFactory $subject
     * @param array $data
     * @return array
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeCreate(
        EntityGeneratorFactory $subject,
        array $data
    ): array {
        $data['customTableMap']['unific_Connector_message_queue'] = [
            'entity_id_field' => EntityGenerator::SKIP_ENTITY_ID_BINDING,
        ];

        return [$data];
    }
}
