<?php

namespace Unific\Connector\Api\Data;

use Magento\Framework\Api\ExtensibleDataInterface;

interface IntegrationInterface extends ExtensibleDataInterface
{
    /**
     * @return string|null
     */
    public function getIntegrationId();

    /**
     * @param string $id
     * @return $this
     */
    public function setIntegrationId($id);

    /**
     * @return string|null
     */
    public function getEndpoint();

    /**
     * @param string $endpoint
     * @return $this
     */
    public function setEndpoint($endpoint);

    /**
     * Retrieve existing extension attributes object or create a new one.
     *
     * @return \Unific\Connector\Api\Data\IntegrationExtensionInterface|null
     */
    public function getExtensionAttributes();

    /**
     * Set an extension attributes object.
     *
     * @param \Unific\Connector\Api\Data\IntegrationExtensionInterface $extensionAttributes
     * @return $this
     */
    public function setExtensionAttributes(
        \Unific\Connector\Api\Data\IntegrationExtensionInterface $extensionAttributes
    );
}
