<?php

namespace Unific\Connector\Api\Data;

use Magento\Framework\Api\ExtensibleDataInterface;

interface SetupResponseInterface extends ExtensibleDataInterface
{
    /**
     * @return \Unific\Connector\Api\Data\HmacInterface|null
     */
    public function getHmac();

    /**
     * @param \Unific\Connector\Api\Data\HmacInterface $hmacInterface
     * @return $this
     */
    public function setHmac(\Unific\Connector\Api\Data\HmacInterface $hmacInterface);

    /**
     * @return \Unific\Connector\Api\Data\TotalsInterface|null
     */
    public function getTotals();

    /**
     * @param \Unific\Connector\Api\Data\TotalsInterface $totalsInterface
     * @return $this
     */
    public function setTotals(\Unific\Connector\Api\Data\TotalsInterface $totalsInterface);

    /**
     * Retrieve existing extension attributes object or create a new one.
     *
     * @return \Unific\Connector\Api\Data\SetupResponseExtensionInterface|null
     */
    public function getExtensionAttributes();

    /**
     * Set an extension attributes object.
     *
     * @param \Unific\Connector\Api\Data\SetupResponseExtensionInterface $extensionAttributes
     * @return $this
     */
    public function setExtensionAttributes(
        \Unific\Connector\Api\Data\SetupResponseExtensionInterface $extensionAttributes
    );
}
