<?php

namespace Unific\Connector\Api;

use Unific\Connector\Api\Data\FiltersInterface;
use Unific\Connector\Api\Data\HistoricalResultInterface;

interface HistoricalManagementInterface
{
    /**
     * Triggers the historical process
     *
     * @api
     *
     * @param string|null $jobId (optional) Job ID. If null, a default process will be used.
     * @return bool true on success
     */
    public function triggerHistorical(?string $jobId = null);

    /**
     * Triggers the historical process
     *
     * @api
     *
     * @param string $type
     * @param string|null $jobId (optional) Job ID. If null, a default process will be used.
     * @return bool true on success
     */
    public function triggerHistoricalForType($type, ?string $jobId = null);

    /**
     * @param string $type
     * @param int $id
     * @param string|null $jobId (optional) Job ID. If null, a default process will be used.
     * @return bool true on success
     */
    public function triggerHistoricalForTypeAndId($type, $id, ?string $jobId = null);

    /**
     * @param string $type
     * @param string $code
     * @param string|null $jobId (optional) Job ID. If null, a default process will be used.
     * @return bool true on success
     */
    public function triggerHistoricalForTypeAndStore($type, $code, ?string $jobId = null);

    /**
     * Stop historical jobs.
     *
     * @param string|null $jobId (optional) Job ID to stop. If null, stop all jobs.
     * @return array
     */
    public function stopHistorical(?string $jobId = null): array;

    /**
     * Stop the historical process for a given type
     *
     * @api
     *
     * @param string $type
     * @return bool true on success
     */
    public function stopHistoricalForType($type, ?string $jobId = null);

    /**
     * Pause historical jobs.
     *
     * @param string|null $jobId (optional) Job ID to pause. If null, pause all jobs.
     * @return array
     */
    public function pauseHistorical(?string $jobId = null): array;

    /**
     * Pause the historical process for a given type
     *
     * @api
     *
     * @param string $type
     * @return bool true on success
     */
    public function pauseHistoricalForType($type, ?string $jobId = null);

    /**
     * Resume the historical process
     *
     * @api
     *
     * @param string|null $jobId (optional) Job ID to resume. If null, resume all jobs.
     * @return bool true on success
     */
    public function resumeHistorical(?string $jobId = null);

    /**
     * Resume the historical process for a given type
     *
     * @api
     *
     * @param string $type
     * @param string|null $jobId (optional) Job ID to resume. If null, resume all jobs.
     * @return bool true on success
     */
    public function resumeHistoricalForType($type, ?string $jobId = null);

    /**
     * Trigger partial historical data processing
     *
     * @param \Unific\Connector\Api\Data\FiltersInterface $filters
     * @return \Unific\Connector\Api\Data\HistoricalResultInterface
     */
    public function triggerPartialHistorical(FiltersInterface $filters, ?string $jobId = null);
}
