<?php

namespace Unific\Connector\Model\Api\Data;

use Magento\Framework\DataObject;

class SetupResponse extends DataObject implements \Unific\Connector\Api\Data\SetupResponseInterface
{
    const KEY_HMAC = 'hmac';
    const KEY_TOTALS = 'totals';
    const KEY_EXTENSION_ATTRIBUTES = 'extension_attributes';

    /**
     * @return \Unific\Connector\Api\Data\HmacInterface|null
     */
    public function getHmac()
    {
        return $this->getData(self::KEY_HMAC);
    }

    /**
     * @param \Unific\Connector\Api\Data\HmacInterface $hmac
     * @return $this
     */
    public function setHmac(\Unific\Connector\Api\Data\HmacInterface $hmac)
    {
        return $this->setData(self::KEY_HMAC, $hmac);
    }

    /**
     * @return \Unific\Connector\Api\Data\TotalsInterface|null
     */
    public function getTotals()
    {
        return $this->getData(self::KEY_TOTALS);
    }

    /**
     * @param \Unific\Connector\Api\Data\TotalsInterface $totals
     * @return $this
     */
    public function setTotals(\Unific\Connector\Api\Data\TotalsInterface $totals)
    {
        return $this->setData(self::KEY_TOTALS, $totals);
    }

    /**
     * {@inheritdoc}
     */
    public function getExtensionAttributes()
    {
        return $this->getData(self::KEY_EXTENSION_ATTRIBUTES);
    }

    /**
     * {@inheritdoc}
     */
    public function setExtensionAttributes(
        \Unific\Connector\Api\Data\SetupResponseExtensionInterface $extensionAttributes
    ) {
        return $this->setData(self::KEY_EXTENSION_ATTRIBUTES, $extensionAttributes);
    }
}
