<?php

namespace Unific\Connector\Model\Api\Data;

use Magento\Framework\DataObject;

class Totals extends DataObject implements \Unific\Connector\Api\Data\TotalsInterface
{
    const KEY_CATEGORY = 'category';
    const KEY_PRODUCT = 'product';
    const KEY_CUSTOMER = 'customer';
    const KEY_ORDER = 'order';
    const KEY_EXTENSION_ATTRIBUTES = 'extension_attributes';

    /**
     * @return int|null
     */
    public function getCategory()
    {
        return $this->getData(self::KEY_CATEGORY);
    }

    /**
     * @param int $category
     * @return $this
     */
    public function setCategory($category = 0)
    {
        return $this->setData(self::KEY_CATEGORY, $category);
    }

    /**
     * @return int|null
     */
    public function getProduct()
    {
        return $this->getData(self::KEY_PRODUCT);
    }

    /**
     * @param int $product
     * @return $this
     */
    public function setProduct($product = 0)
    {
        return $this->setData(self::KEY_PRODUCT, $product);
    }

    /**
     * @return int|null
     */
    public function getCustomer()
    {
        return $this->getData(self::KEY_CUSTOMER);
    }

    /**
     * @param int $customer
     * @return $this
     */
    public function setCustomer($customer = 0)
    {
        return $this->setData(self::KEY_CUSTOMER, $customer);
    }

    /**
     * @return int|null
     */
    public function getOrder()
    {
        return $this->getData(self::KEY_ORDER);
    }

    /**
     * @param int $order
     * @return $this
     */
    public function setOrder($order = 0)
    {
        return $this->setData(self::KEY_ORDER, $order);
    }

    /**
     * {@inheritdoc}
     */
    public function getExtensionAttributes()
    {
        return $this->getData(self::KEY_EXTENSION_ATTRIBUTES);
    }

    /**
     * {@inheritdoc}
     */
    public function setExtensionAttributes(
        \Unific\Connector\Api\Data\TotalsExtensionInterface $extensionAttributes
    ) {
        return $this->setData(self::KEY_EXTENSION_ATTRIBUTES, $extensionAttributes);
    }
}
