<?php

namespace Unific\Connector\Model\Api;

use Unific\Connector\Api\HistoricalManagementInterface;
use Unific\Connector\Api\Data\HistoricalResultInterface;
use Unific\Connector\Api\Data\HistoricalResultInterfaceFactory;
use Unific\Connector\Api\Data\FiltersInterface;
use Magento\Framework\Exception\LocalizedException;

class HistoricalManagement implements HistoricalManagementInterface
{
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    protected $historicalHelper;

    protected $historicalResultFactory;

    /**
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Unific\Connector\Helper\Historical $historicalHelper
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Unific\Connector\Helper\Historical $historicalHelper,
        HistoricalResultInterfaceFactory $historicalResultFactory
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->historicalHelper = $historicalHelper;
        $this->historicalResultFactory = $historicalResultFactory;
    }

    /**
     * @api
     *
     * @param string|null $jobId
     * @return array
     */
    public function triggerHistorical(?string $jobId = null)
    {
        return $this->historicalHelper->triggerHistorical($jobId);
    }

    /**
     * @api
     *
     * @param string $type
     * @param string|null $jobId
     * @return array
     */
    public function triggerHistoricalForType($type, ?string $jobId = null)
    {
        return $this->historicalHelper->triggerHistoricalForType($type, $jobId, true);
    }

    /**
     * @param string $type
     * @param int $id
     * @param string|null $jobId
     * @return array
     */
    public function triggerHistoricalForTypeAndId($type, $id, ?string $jobId = null)
    {
        return $this->historicalHelper->triggerHistoricalForType(implode('_', [$type, $id]), $jobId, true);
    }

    /**
     * @param string $type
     * @param string $code
     * @param string|null $jobId
     * @return array
     */
    public function triggerHistoricalForTypeAndStore($type, $code, ?string $jobId = null)
    {
        return $this->historicalHelper->triggerHistoricalForType(implode(':', [$type, $code]), $jobId, true);
    }

    /**
     * @api
     *
     * @param string $type
     * @return array
     */
    public function stopHistoricalForType($type, ?string $jobId = null)
    {
        return $this->historicalHelper->resetHistoricalForType($type, $jobId);
    }

    /**
     * @api
     *
     * @return array
     */
    public function stopHistorical(?string $jobId = null): array
    {
        return $this->historicalHelper->resetAllHistoricalData($jobId);
    }

    /**
     * @api
     *
     * @return array
     */
    public function pauseHistorical(?string $jobId = null): array
    {
        return $this->historicalHelper->pauseHistorical($jobId);
    }

    /**
     * @api
     *
     * @return array
     */
    public function resumeHistorical(?string $jobId = null)
    {
        return $this->historicalHelper->resumeHistorical($jobId);
    }

    /**
     * @api
     *
     * @return array
     */
    public function pauseHistoricalForType($type, $jobId = null)
    {
        return $this->historicalHelper->pauseHistoricalForType($type, $jobId);
    }

    /**
     * @api
     *
     * @return array
     */
    public function resumeHistoricalForType($type, $jobId = null)
    {
        return $this->historicalHelper->resumeHistoricalForType($type, $jobId);
    }

    public function triggerPartialHistorical(FiltersInterface $filters,  $jobId = null)
    {
        $type = $filters->getType();
        $startDatetime = $filters->getStartDatetime();
        $endDatetime = $filters->getEndDatetime();
        $dateField = $filters->getDateField();
        $identifiers = $filters->getIdentifiers();

        if (!$type) {
            throw new LocalizedException(__('The "type" parameter is required.'));
        }

        $resultData = $this->historicalHelper->processImmediateHistorical(
            $type,
            $startDatetime,
            $endDatetime,
            $dateField,
            $identifiers,
            $jobId
        );

        /** @var HistoricalResultInterface $result */
        $result = $this->historicalResultFactory->create();
        $result->setMessage($resultData['message']);

        return $result;
    }
}
