<?php

namespace Unific\Connector\Plugin;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\ProductMetadataInterface;
use Magento\Framework\Module\ModuleListInterface;
use Magento\Quote\Model\QuoteRepository;
use Magento\Quote\Api\Data\CartInterface;
use Magento\Store\Model\App\Emulation;
use Unific\Connector\Helper\Data\Cart;
use Unific\Connector\Helper\Hmac;
use Unific\Connector\Helper\Message\Queue;
use Unific\Connector\Helper\Settings;

class QuoteRepositoryPlugin extends AbstractPlugin
{
    /**
     * @var Cart
     */
    protected $cartDataHelper;

    /**
     * @param Cart $cartDataHelper
     * @param ScopeConfigInterface $scopeConfig
     * @param Hmac $hmacHelper
     * @param Queue $queueHelper
     * @param ProductMetadataInterface $productMetadata
     * @param ModuleListInterface $moduleList
     * @param Emulation $emulation
     */
    public function __construct(
        Cart $cartDataHelper,
        ScopeConfigInterface $scopeConfig,
        Hmac $hmacHelper,
        Queue $queueHelper,
        ProductMetadataInterface $productMetadata,
        ModuleListInterface $moduleList,
        Emulation $emulation
    ) {
        parent::__construct(
            $scopeConfig,
            $hmacHelper,
            $queueHelper,
            $productMetadata,
            $moduleList,
            $emulation
        );

        $this->cartDataHelper = $cartDataHelper;
    }

    /**
     * @param QuoteRepository $subject
     * @param CartInterface $quote
     * @return void
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function afterSave(
        QuoteRepository $subject,
                        $result,
        CartInterface $quote
    ) {
        if ($this->isConnectorEnabled($quote->getStoreId()) && $this->isUseQuoteRepositoryPluginEnabled($quote->getStoreId())) {
            $this->cartDataHelper->setCart($quote);

            $integrationSubject = 'checkout/create';

            // Magento adds the created at tag, if the created date differs from the current change
            if ($this->cartDataHelper->getCart()->getCreatedAt() != null) {
                $integrationSubject = 'checkout/update';
            }

            $this->processWebhook(
                $this->cartDataHelper->getCartInfo(),
                $this->scopeConfig->getValue('unific/webhook/cart_endpoint'),
                Settings::PRIORITY_CART,
                $integrationSubject
            );
        }
    }
}
